; -------------------------------------------------------------------------------------

;	RCS Header $Id: math16.inc 2.4 1997/02/11 16:58:49 F.J.Testa Exp $
; 	Modified by Malcolm Wiles, 25 May 2004

;	$Revision: 2.4 $

;       MATH16 INCLUDE FILE
;
	NOLIST

;       IMPORTANT NOTE: The math library routines can be used in a dedicated application on
;       an individual basis and memory allocation may be modified with the stipulation that
;       on the PIC17, P type registers must remain so since P type specific instructions
;	were used to realize some performance improvements.

;*********************************************************************************************
;
;       GENERAL MATH LIBRARY DEFINITIONS
;
;	general literal constants

;	define assembler constants

MSB		equ	7
LSB		equ	0


;     define commonly used bits

;     STATUS bit definitions

		#define	_C		STATUS,0
		#define	_Z		STATUS,2


;*********************************************************************************************
;
;       FLOATING POINT SPECIFIC DEFINITIONS
;
;       literal constants
;
EXPBIAS         equ     D'127'
;
;       biased exponents
;


;
;       floating point library exception flags
;
                
IOV             equ     0       ; bit0 = integer overflow flag
FOV             equ     1       ; bit1 = floating point overflow flag
FUN             equ     2       ; bit2 = floating point underflow flag
FDZ             equ     3       ; bit3 = floating point divide by zero flag
NAN		equ	4	; bit4 = not-a-number exception flag
DOM		equ	5	; bit5 = domain error exception flag
RND             equ     6       ; bit6 = floating point rounding flag, 0 = truncation
                                ; 1 = unbiased rounding to nearest LSB
SAT             equ     7       ; bit7 = floating point saturate flag, 0 = terminate on
                                ; exception without saturation, 1 = terminate on
                                ; exception with saturation to appropriate value

; well known constants

PIEXP		equ	0x80	; PI in floating point
PIB0		equ	0x49
PIB1		equ	0x0F

		LIST
;**********************************************************************************************
